/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import java.util.Optional;
import retrofit.RetrofitError;

@NonnullByDefault
public class SpinnakerServerException
extends SpinnakerException {
    private final String rawMessage;

    public SpinnakerServerException(RetrofitError e) {
        super(e.getCause());
        RetrofitErrorResponseBody body = (RetrofitErrorResponseBody)e.getBodyAs(RetrofitErrorResponseBody.class);
        this.rawMessage = Optional.ofNullable(body).map(RetrofitErrorResponseBody::getMessage).orElse("");
    }

    public String getMessage() {
        return this.rawMessage;
    }

    final String getRawMessage() {
        return this.rawMessage;
    }

    private static final class RetrofitErrorResponseBody {
        private final String message;

        @JsonCreator
        RetrofitErrorResponseBody(@JsonProperty(value="message") String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

