/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerNetworkException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import org.springframework.http.HttpStatus;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;

@NonnullByDefault
public final class SpinnakerRetrofitErrorHandler
implements ErrorHandler {
    private SpinnakerRetrofitErrorHandler() {
    }

    public static SpinnakerRetrofitErrorHandler getInstance() {
        return new SpinnakerRetrofitErrorHandler();
    }

    public Throwable handleError(RetrofitError e) {
        switch (e.getKind()) {
            case HTTP: {
                if (e.getResponse().getStatus() == HttpStatus.NOT_FOUND.value()) {
                    return new NotFoundException((Throwable)e).setRetryable(Boolean.valueOf(false));
                }
                SpinnakerHttpException retval = new SpinnakerHttpException(e);
                if (e.getResponse().getStatus() == HttpStatus.BAD_REQUEST.value()) {
                    retval.setRetryable(false);
                }
                return retval;
            }
            case NETWORK: {
                return new SpinnakerNetworkException(e);
            }
        }
        return new SpinnakerServerException(e);
    }
}

