/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import retrofit.RetrofitError;
import retrofit.client.Response;

@NonnullByDefault
public class SpinnakerHttpException
extends SpinnakerServerException {
    private final Response response;

    public SpinnakerHttpException(RetrofitError e) {
        super(e);
        this.response = e.getResponse();
    }

    public SpinnakerHttpException(String message, SpinnakerHttpException cause) {
        super(message, (Throwable)((Object)cause));
        this.response = cause.getResponse();
    }

    @Override
    public String getMessage() {
        if (this.getRawMessage() == null) {
            return super.getMessage();
        }
        return String.format("Status: %s, URL: %s, Message: %s", this.response.getStatus(), this.response.getUrl(), this.getRawMessage());
    }

    public Response getResponse() {
        return this.response;
    }
}

