/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import com.netflix.spinnaker.kork.web.exceptions.BaseExceptionHandlers;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Order(value=0x7FFFFFFE)
public class SpinnakerRetrofitExceptionHandlers
extends BaseExceptionHandlers {
    private static final Logger logger = LoggerFactory.getLogger(SpinnakerRetrofitExceptionHandlers.class);

    public SpinnakerRetrofitExceptionHandlers(ExceptionMessageDecorator exceptionMessageDecorator) {
        super(exceptionMessageDecorator);
    }

    @ExceptionHandler(value={SpinnakerServerException.class})
    public void handleSpinnakerServerException(SpinnakerServerException e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, (Exception)((Object)e));
        logger.error(e.getMessage(), (Throwable)((Object)e));
        response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), this.exceptionMessageDecorator.decorate((Throwable)((Object)e), e.getMessage()));
    }

    @ExceptionHandler(value={SpinnakerHttpException.class})
    public void handleSpinnakerHttpException(SpinnakerHttpException e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, (Exception)((Object)e));
        int status = e.getResponseCode();
        HttpStatus httpStatus = HttpStatus.resolve((int)status);
        if (httpStatus.is5xxServerError()) {
            logger.error(e.getMessage(), (Throwable)((Object)e));
        } else {
            logger.debug(e.getMessage());
        }
        response.sendError(status, this.exceptionMessageDecorator.decorate((Throwable)((Object)e), e.getMessage()));
    }
}

