/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Objects;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class RetrofitException
extends RuntimeException {
    private final Response response;
    private final Retrofit retrofit;

    public static RetrofitException httpError(Response response, Retrofit retrofit) {
        String message = response.code() + " " + response.message();
        return new RetrofitException(message, response, null, retrofit);
    }

    public static RetrofitException networkError(IOException exception) {
        return new RetrofitException(exception.getMessage(), null, exception, null);
    }

    public static RetrofitException unexpectedError(Throwable exception) {
        return new RetrofitException(exception.getMessage(), null, exception, null);
    }

    RetrofitException(String message, Response response, Throwable exception, Retrofit retrofit) {
        super(message, exception);
        this.response = response;
        if (response != null) {
            Objects.requireNonNull(response.errorBody());
        }
        this.retrofit = retrofit;
    }

    public Response getResponse() {
        return this.response;
    }

    public <T> T getErrorBodyAs(Class<T> type) {
        if (this.response == null) {
            return null;
        }
        Converter converter = this.retrofit.responseBodyConverter(type, new Annotation[0]);
        try {
            return (T)converter.convert((Object)this.response.errorBody());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

