/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.google.common.base.Preconditions;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.retrofit.exceptions.RetrofitException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import retrofit.RetrofitError;
import retrofit2.Response;

@NonnullByDefault
public class SpinnakerHttpException
extends SpinnakerServerException {
    private final retrofit.client.Response response;
    private HttpHeaders headers;
    private final Response retrofit2Response;
    private final String rawMessage;
    private final Map<String, Object> responseBody;

    public SpinnakerHttpException(RetrofitError e) {
        super((Throwable)e);
        this.response = e.getResponse();
        this.retrofit2Response = null;
        this.responseBody = (Map)e.getBodyAs(HashMap.class);
        this.rawMessage = this.responseBody != null ? (String)this.responseBody.getOrDefault("message", e.getMessage()) : e.getMessage();
    }

    public SpinnakerHttpException(RetrofitException e) {
        super(e);
        this.response = null;
        this.retrofit2Response = e.getResponse();
        this.responseBody = e.getErrorBodyAs(HashMap.class);
        this.rawMessage = this.responseBody != null ? (String)this.responseBody.getOrDefault("message", e.getMessage()) : e.getMessage();
    }

    private final String getRawMessage() {
        return this.rawMessage;
    }

    public SpinnakerHttpException(String message, SpinnakerHttpException cause) {
        super(message, (Throwable)((Object)cause));
        Preconditions.checkState((cause.response == null || cause.retrofit2Response == null ? 1 : 0) != 0, (Object)"Can't set both response and retrofit2Response");
        this.response = cause.response;
        this.retrofit2Response = cause.retrofit2Response;
        this.rawMessage = null;
        this.responseBody = cause.responseBody;
    }

    public int getResponseCode() {
        if (this.response != null) {
            return this.response.getStatus();
        }
        return this.retrofit2Response.code();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            if (this.response != null) {
                this.response.getHeaders().forEach(header -> this.headers.add(header.getName(), header.getValue()));
            } else {
                this.retrofit2Response.headers().names().forEach(key -> this.headers.addAll(key, this.retrofit2Response.headers().values(key)));
            }
        }
        return this.headers;
    }

    public String getMessage() {
        if (this.getRawMessage() == null) {
            return super.getMessage();
        }
        if (this.retrofit2Response != null) {
            return String.format("Status: %s, URL: %s, Message: %s", this.retrofit2Response.code(), this.retrofit2Response.raw().request().url().toString(), this.getRawMessage());
        }
        return String.format("Status: %s, URL: %s, Message: %s", this.response.getStatus(), this.response.getUrl(), this.getRawMessage());
    }

    @Override
    public SpinnakerHttpException newInstance(String message) {
        return new SpinnakerHttpException(message, this);
    }

    public Map<String, Object> getResponseBody() {
        return this.responseBody;
    }
}

