/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.google.common.base.Preconditions;
import com.netflix.spinnaker.kork.annotations.NullableByDefault;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import retrofit.RetrofitError;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

@NullableByDefault
public class SpinnakerHttpException
extends SpinnakerServerException {
    private static final Logger log = LoggerFactory.getLogger(SpinnakerHttpException.class);
    private final retrofit.client.Response response;
    private HttpHeaders headers;
    private final Response<?> retrofit2Response;
    private final String rawMessage;
    private final Map<String, Object> responseBody;
    private final String url;
    private final int responseCode;
    private final String reason;

    public SpinnakerHttpException(RetrofitError e) {
        super((Throwable)e);
        Objects.requireNonNull(e.getResponse(), "SpinnakerHttpException requires a Response object");
        this.response = e.getResponse();
        this.retrofit2Response = null;
        String tmpMessage = null;
        Map body = null;
        try {
            body = (Map)e.getBodyAs(HashMap.class);
        }
        catch (Exception responseBodyException) {
            log.debug("unable to convert response to map ({}, {})", new Object[]{e.getUrl(), e.getMessage(), responseBodyException});
        }
        this.responseBody = body;
        if (this.responseBody != null) {
            tmpMessage = (String)this.responseBody.get("message");
        }
        this.url = e.getUrl();
        this.responseCode = this.response.getStatus();
        this.reason = this.response.getReason();
        this.rawMessage = tmpMessage != null ? tmpMessage : this.reason;
    }

    public SpinnakerHttpException(Response<?> retrofit2Response, Retrofit retrofit) {
        this.response = null;
        this.retrofit2Response = retrofit2Response;
        if (retrofit2Response.code() == HttpStatus.NOT_FOUND.value() || retrofit2Response.code() == HttpStatus.BAD_REQUEST.value()) {
            this.setRetryable(false);
        }
        this.responseBody = this.getErrorBodyAs(retrofit);
        this.url = retrofit2Response.raw().request().url().toString();
        this.responseCode = retrofit2Response.code();
        this.reason = retrofit2Response.message();
        this.rawMessage = this.responseBody != null ? (String)this.responseBody.getOrDefault("message", retrofit2Response.message()) : retrofit2Response.message();
    }

    private String getRawMessage() {
        return this.rawMessage;
    }

    public SpinnakerHttpException(String message, SpinnakerHttpException cause) {
        super(message, (Throwable)((Object)cause));
        Preconditions.checkState((cause.response == null || cause.retrofit2Response == null ? 1 : 0) != 0, (Object)"Can't set both response and retrofit2Response");
        this.response = cause.response;
        this.retrofit2Response = cause.retrofit2Response;
        this.rawMessage = null;
        this.responseBody = cause.responseBody;
        this.url = cause.url;
        this.responseCode = cause.responseCode;
        this.reason = cause.reason;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Nonnull
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            if (this.response != null) {
                this.response.getHeaders().forEach(header -> this.headers.add(header.getName(), header.getValue()));
            } else {
                this.retrofit2Response.headers().names().forEach(key -> this.headers.addAll(key, this.retrofit2Response.headers().values(key)));
            }
        }
        return this.headers;
    }

    public String getMessage() {
        if (this.getRawMessage() == null) {
            return super.getMessage();
        }
        return String.format("Status: %s, URL: %s, Message: %s", this.responseCode, this.url, this.getRawMessage());
    }

    @Override
    public SpinnakerHttpException newInstance(String message) {
        return new SpinnakerHttpException(message, this);
    }

    public Map<String, Object> getResponseBody() {
        return this.responseBody;
    }

    public String getUrl() {
        return this.url;
    }

    public String getReason() {
        return this.reason;
    }

    private Map<String, Object> getErrorBodyAs(Retrofit retrofit) {
        if (this.retrofit2Response == null) {
            return null;
        }
        Converter converter = retrofit.responseBodyConverter(Map.class, new Annotation[0]);
        try {
            return (Map)converter.convert((Object)this.retrofit2Response.errorBody());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

