/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerConversionException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerNetworkException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;

@NonnullByDefault
public final class SpinnakerRetrofitErrorHandler
implements ErrorHandler {
    private SpinnakerRetrofitErrorHandler() {
    }

    public static SpinnakerRetrofitErrorHandler getInstance() {
        return new SpinnakerRetrofitErrorHandler();
    }

    public Throwable handleError(RetrofitError e) {
        switch (e.getKind()) {
            case HTTP: {
                SpinnakerHttpException retval = new SpinnakerHttpException(e);
                if (e.getResponse().getStatus() == HttpStatus.NOT_FOUND.value() || e.getResponse().getStatus() == HttpStatus.BAD_REQUEST.value()) {
                    retval.setRetryable(false);
                }
                return retval;
            }
            case NETWORK: {
                return new SpinnakerNetworkException(e.getMessage(), e.getCause());
            }
            case CONVERSION: {
                return new SpinnakerConversionException(e.getMessage(), e.getCause());
            }
        }
        return new SpinnakerServerException(e.getMessage(), e.getCause());
    }

    public Throwable handleError(RetrofitError e, Function<Throwable, String> messageBuilder) {
        Throwable exception = this.handleError(e);
        if (exception instanceof SpinnakerException) {
            return ((SpinnakerException)exception).newInstance(messageBuilder.apply(exception));
        }
        return exception;
    }
}

