/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jakewharton.retrofit.Ok3Client;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.client.ServiceClientFactory;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerRetrofitErrorHandler;
import com.netflix.spinnaker.retrofit.Slf4jRetrofitLogger;
import java.util.List;
import okhttp3.Interceptor;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@NonnullByDefault
class RetrofitServiceFactory
implements ServiceClientFactory {
    private final RestAdapter.LogLevel retrofitLogLevel;
    private final OkHttpClientProvider clientProvider;
    private final RequestInterceptor spinnakerRequestInterceptor;

    RetrofitServiceFactory(RestAdapter.LogLevel retrofitLogLevel, OkHttpClientProvider clientProvider, RequestInterceptor spinnakerRequestInterceptor) {
        this.retrofitLogLevel = retrofitLogLevel;
        this.clientProvider = clientProvider;
        this.spinnakerRequestInterceptor = spinnakerRequestInterceptor;
    }

    public <T> T create(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper) {
        Endpoint endpoint = Endpoints.newFixedEndpoint((String)serviceEndpoint.getBaseUrl());
        return (T)new RestAdapter.Builder().setRequestInterceptor(this.spinnakerRequestInterceptor).setConverter((Converter)new JacksonConverter(objectMapper)).setEndpoint(endpoint).setErrorHandler((ErrorHandler)SpinnakerRetrofitErrorHandler.getInstance()).setClient((Client)new Ok3Client(this.clientProvider.getClient(serviceEndpoint))).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new Slf4jRetrofitLogger(type)).build().create(type);
    }

    public <T> T create(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper, List<Interceptor> interceptors) {
        throw new IllegalArgumentException(String.format("Retrofit1 client doesn't support okhttp3 Interceptors. Failed to build %s ", type.getName()));
    }
}

