/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit.exceptions;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import okhttp3.Request;
import retrofit.RetrofitError;

@NonnullByDefault
public class SpinnakerServerException
extends SpinnakerException {
    private final String url;
    private final String httpMethod;

    public SpinnakerServerException(RetrofitError e) {
        super(e.getMessage(), e.getCause());
        this.url = e.getUrl();
        this.httpMethod = null;
    }

    public SpinnakerServerException(Request request) {
        this.url = request.url().toString();
        this.httpMethod = request.method();
    }

    public SpinnakerServerException(Throwable cause, Request request) {
        super(cause);
        this.url = request.url().toString();
        this.httpMethod = request.method();
    }

    public SpinnakerServerException(String message, Throwable cause, Request request) {
        super(message, cause);
        this.url = request.url().toString();
        this.httpMethod = request.method();
    }

    public SpinnakerServerException(String message, SpinnakerServerException cause) {
        super(message, (Throwable)((Object)cause));
        this.url = cause.getUrl();
        this.httpMethod = cause.getHttpMethod();
    }

    public SpinnakerServerException newInstance(String message) {
        return new SpinnakerServerException(message, this);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }
}

