/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerConversionException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerNetworkException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import okhttp3.Request;
import okio.Timeout;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ErrorHandlingExecutorCallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Executor callbackExecutor;

    ErrorHandlingExecutorCallAdapterFactory() {
        this.callbackExecutor = null;
    }

    ErrorHandlingExecutorCallAdapterFactory(Executor callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    public static ErrorHandlingExecutorCallAdapterFactory getInstance(Executor callbackExecutor) {
        return new ErrorHandlingExecutorCallAdapterFactory(callbackExecutor);
    }

    public static ErrorHandlingExecutorCallAdapterFactory getInstance() {
        return new ErrorHandlingExecutorCallAdapterFactory();
    }

    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, final Retrofit retrofit) {
        if (ErrorHandlingExecutorCallAdapterFactory.getRawType((Type)returnType) != Call.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            return null;
        }
        final Type responseType = ErrorHandlingExecutorCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        return new CallAdapter<Object, Call<?>>(){

            public Type responseType() {
                return responseType;
            }

            public Call<Object> adapt(Call<Object> call) {
                return new ExecutorCallbackCall<Object>(ErrorHandlingExecutorCallAdapterFactory.this.callbackExecutor, call, retrofit);
            }
        };
    }

    static class SpinnakerCustomExecutorCallback<T>
    implements Callback<T> {
        private final Executor callbackExecutor;
        private final Callback<T> callback;
        private final ExecutorCallbackCall<T> executorCallbackCall;

        public SpinnakerCustomExecutorCallback(Executor callbackExecutor, Callback<T> callback, ExecutorCallbackCall<T> executorCallbackCall) {
            this.callbackExecutor = callbackExecutor;
            this.callback = callback;
            this.executorCallbackCall = executorCallbackCall;
        }

        public void onResponse(Call<T> call, final Response<T> response) {
            if (response.isSuccessful()) {
                this.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onResponse(executorCallbackCall, response);
                    }
                });
            } else {
                this.callbackExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(executorCallbackCall, (Throwable)((Object)new SpinnakerHttpException(response, executorCallbackCall.retrofit)));
                    }
                });
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            SpinnakerServerException exception = t instanceof IOException ? new SpinnakerNetworkException(t, call.request()) : (t instanceof SpinnakerHttpException ? (SpinnakerHttpException)((Object)t) : new SpinnakerServerException(t, call.request()));
            final SpinnakerServerException finalException = exception;
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(executorCallbackCall, (Throwable)((Object)finalException));
                }
            });
        }
    }

    static final class ExecutorCallbackCall<T>
    implements Call<T> {
        private final Executor callbackExecutor;
        private final Call<T> delegate;
        private final Retrofit retrofit;

        ExecutorCallbackCall(Executor callbackExecutor, Call<T> delegate, Retrofit retrofit) {
            this.callbackExecutor = callbackExecutor;
            this.delegate = delegate;
            this.retrofit = retrofit;
        }

        public Response<T> execute() {
            Response syncResp = null;
            try {
                syncResp = this.delegate.execute();
                if (syncResp.isSuccessful()) {
                    return syncResp;
                }
            }
            catch (JsonProcessingException jpe) {
                throw new SpinnakerConversionException("Failed to process response body: " + jpe.getMessage(), jpe, this.delegate.request());
            }
            catch (IOException e) {
                throw new SpinnakerNetworkException(e, this.delegate.request());
            }
            catch (Exception e) {
                throw new SpinnakerServerException(e, this.delegate.request());
            }
            throw new SpinnakerHttpException(syncResp, this.retrofit);
        }

        public void enqueue(Callback<T> callback) {
            Objects.requireNonNull(callback, "Callback can't be null");
            this.delegate.enqueue(new SpinnakerCustomExecutorCallback<T>(this.callbackExecutor, callback, this));
        }

        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        public Call<T> clone() {
            return new ExecutorCallbackCall<T>(this.callbackExecutor, this.delegate.clone(), this.retrofit);
        }

        public Request request() {
            return this.delegate.request();
        }

        public Timeout timeout() {
            return this.delegate.timeout();
        }
    }
}

