/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.client.ServiceClientFactory;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@NonnullByDefault
public class Retrofit2ServiceFactory
implements ServiceClientFactory {
    private final OkHttpClientProvider clientProvider;

    public Retrofit2ServiceFactory(OkHttpClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public <T> T create(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper) {
        return this.create(type, serviceEndpoint, objectMapper, List.of());
    }

    public <T> T create(Class<T> type, ServiceEndpoint serviceEndpoint, ObjectMapper objectMapper, List<Interceptor> interceptors) {
        OkHttpClient okHttpClient = this.clientProvider.getClient(serviceEndpoint, interceptors);
        return (T)new Retrofit.Builder().baseUrl(Objects.requireNonNull(HttpUrl.parse((String)serviceEndpoint.getBaseUrl()))).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).build().create(type);
    }

    public boolean supports(Class<?> type, ServiceEndpoint serviceEndpoint) {
        return type.getMethods()[0].getReturnType().getName().equalsIgnoreCase(Call.class.getName());
    }
}

