/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.retrofit;

import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.client.ServiceClientFactory;
import com.netflix.spinnaker.kork.retrofit.Retrofit2ConfigurationProperties;
import com.netflix.spinnaker.kork.retrofit.Retrofit2ServiceFactory;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnProperty(value={"retrofit2.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={Retrofit2ConfigurationProperties.class})
public class Retrofit2ServiceFactoryAutoConfiguration {
    @Bean
    @Order(value=0x7FFFFFFE)
    ServiceClientFactory serviceClientFactory2(OkHttpClientProvider clientProvider) {
        return new Retrofit2ServiceFactory(clientProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    HttpLoggingInterceptor httpLoggingInterceptor(Retrofit2ConfigurationProperties retrofit2ConfigurationProperties) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(retrofit2ConfigurationProperties.getLogLevel());
        return httpLoggingInterceptor;
    }
}

