/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.SecretException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SecretsManagerSecretEngine
implements SecretEngine {
    protected static final String SECRET_NAME = "s";
    protected static final String SECRET_REGION = "r";
    protected static final String SECRET_KEY = "k";
    private static String IDENTIFIER = "secrets-manager";
    private Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private static final ObjectMapper mapper = new ObjectMapper();

    public String identifier() {
        return IDENTIFIER;
    }

    public byte[] decrypt(EncryptedSecret encryptedSecret) {
        String secretRegion = (String)encryptedSecret.getParams().get(SECRET_REGION);
        String secretName = (String)encryptedSecret.getParams().get(SECRET_NAME);
        String secretKey = (String)encryptedSecret.getParams().get(SECRET_KEY);
        if (encryptedSecret.isEncryptedFile()) {
            GetSecretValueResult secretFileValue = this.getSecretValue(secretRegion, secretName);
            if (secretFileValue.getSecretBinary() != null) {
                return secretFileValue.getSecretBinary().array();
            }
            return secretFileValue.getSecretString().getBytes();
        }
        if (secretKey != null) {
            return this.getSecretString(secretRegion, secretName, secretKey);
        }
        return this.getSecretString(secretRegion, secretName);
    }

    public void validate(EncryptedSecret encryptedSecret) {
        Set paramNames = encryptedSecret.getParams().keySet();
        if (!paramNames.contains(SECRET_NAME)) {
            throw new InvalidSecretFormatException("Secret name parameter is missing (s=...)");
        }
        if (!paramNames.contains(SECRET_REGION)) {
            throw new InvalidSecretFormatException("Secret region parameter is missing (r=...)");
        }
        if (encryptedSecret.isEncryptedFile() && paramNames.contains(SECRET_KEY)) {
            throw new InvalidSecretFormatException("Encrypted file should not specify key");
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    protected GetSecretValueResult getSecretValue(String secretRegion, String secretName) {
        AWSSecretsManager client = (AWSSecretsManager)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withRegion(secretRegion)).build();
        GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretName);
        try {
            return client.getSecretValue(getSecretValueRequest);
        }
        catch (AWSSecretsManagerException e) {
            throw new SecretException(String.format("An error occurred when using AWS Secrets Manager to fetch: [secretName: %s, secretRegion: %s]", secretName, secretRegion), (Throwable)e);
        }
    }

    private byte[] getSecretString(String secretRegion, String secretName, String secretKey) {
        if (!this.cache.containsKey(secretName)) {
            String secretString = this.getSecretValue(secretRegion, secretName).getSecretString();
            try {
                Map map = (Map)mapper.readValue(secretString, Map.class);
                this.cache.put(secretName, map);
            }
            catch (JsonProcessingException | IllegalArgumentException e) {
                throw new SecretException(String.format("Failed to parse secret when using AWS Secrets Manager to fetch: [secretName: %s, secretRegion: %s, secretKey: %s]", secretName, secretRegion, secretKey), e);
            }
        }
        return Optional.ofNullable(this.cache.get(secretName).get(secretKey)).orElseThrow(() -> new SecretException(String.format("Specified key not found in AWS Secrets Manager: [secretName: %s, secretRegion: %s, secretKey: %s]", secretName, secretRegion, secretKey))).getBytes();
    }

    private byte[] getSecretString(String secretRegion, String secretName) {
        return this.getSecretValue(secretRegion, secretName).getSecretString().getBytes();
    }
}

