/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.AWSSecretsManagerException;
import com.amazonaws.services.secretsmanager.model.DescribeSecretRequest;
import com.amazonaws.services.secretsmanager.model.DescribeSecretResult;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.Tag;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.StandardSecretParameter;
import com.netflix.spinnaker.kork.secrets.engines.SecretsManagerClientProvider;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadata;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadataField;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import com.netflix.spinnaker.kork.secrets.user.UserSecretSerde;
import com.netflix.spinnaker.kork.secrets.user.UserSecretSerdeFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.stereotype.Component;

@Component
public class SecretsManagerSecretEngine
implements SecretEngine {
    protected static final String SECRET_NAME = "s";
    protected static final String SECRET_REGION = "r";
    protected static final String SECRET_KEY = StandardSecretParameter.KEY.getParameterName();
    private static final String IDENTIFIER = "secrets-manager";
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private final ObjectMapper mapper;
    private final UserSecretSerdeFactory userSecretSerdeFactory;
    private final SecretsManagerClientProvider clientProvider;

    public SecretsManagerSecretEngine(ObjectMapper mapper, UserSecretSerdeFactory userSecretSerdeFactory, SecretsManagerClientProvider clientProvider) {
        this.mapper = mapper;
        this.userSecretSerdeFactory = userSecretSerdeFactory;
        this.clientProvider = clientProvider;
    }

    public String identifier() {
        return IDENTIFIER;
    }

    public byte[] decrypt(EncryptedSecret encryptedSecret) {
        if (encryptedSecret.isEncryptedFile()) {
            GetSecretValueResult secretFileValue = this.getSecretValue(encryptedSecret.getParams());
            if (secretFileValue.getSecretBinary() != null) {
                return SecretsManagerSecretEngine.toByteArray(secretFileValue.getSecretBinary());
            }
            return secretFileValue.getSecretString().getBytes(StandardCharsets.UTF_8);
        }
        return this.getSecretString(encryptedSecret.getParams());
    }

    @NonNull
    public UserSecret decrypt(@NonNull UserSecretReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        this.validate(reference);
        Map parameters = reference.getParameters();
        Map<String, String> tags = this.getSecretDescription(parameters).getTags().stream().filter(tag -> tag.getKey().startsWith("spinnaker:")).collect(Collectors.toMap(Tag::getKey, Tag::getValue));
        String type = tags.get(UserSecretMetadataField.TYPE.getTagKey());
        if (type == null) {
            throw new InvalidSecretFormatException("No " + UserSecretMetadataField.TYPE.getTagKey() + " tag found for " + reference);
        }
        String encoding = tags.getOrDefault(UserSecretMetadataField.ENCODING.getTagKey(), "json");
        List roles = Optional.ofNullable(tags.get(UserSecretMetadataField.ROLES.getTagKey())).stream().flatMap(rolesValue -> Stream.of(rolesValue.split("\\s*,\\s*"))).collect(Collectors.toList());
        UserSecretMetadata metadata = UserSecretMetadata.builder().type(type).encoding(encoding).roles(roles).build();
        UserSecretSerde serde = this.userSecretSerdeFactory.serdeFor(metadata);
        GetSecretValueResult secretValue = this.getSecretValue(parameters);
        ByteBuffer secretBinary = secretValue.getSecretBinary();
        byte[] encodedData = secretBinary != null ? SecretsManagerSecretEngine.toByteArray(secretBinary) : secretValue.getSecretString().getBytes(StandardCharsets.UTF_8);
        return serde.deserialize(encodedData, metadata);
    }

    public void validate(EncryptedSecret encryptedSecret) {
        Set paramNames = encryptedSecret.getParams().keySet();
        if (!paramNames.contains(SECRET_NAME)) {
            throw new InvalidSecretFormatException("Secret name parameter is missing (s=...)");
        }
        if (!paramNames.contains(SECRET_REGION)) {
            throw new InvalidSecretFormatException("Secret region parameter is missing (r=...)");
        }
        if (encryptedSecret.isEncryptedFile() && paramNames.contains(SECRET_KEY)) {
            throw new InvalidSecretFormatException("Encrypted file should not specify key");
        }
    }

    public void validate(@NonNull UserSecretReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        Set paramNames = reference.getParameters().keySet();
        if (!paramNames.contains(SECRET_NAME)) {
            throw new InvalidSecretFormatException("Secret name parameter is missing (s=...)");
        }
        if (!paramNames.contains(SECRET_REGION)) {
            throw new InvalidSecretFormatException("Secret region parameter is missing (r=...)");
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    protected DescribeSecretResult getSecretDescription(Map<String, String> parameters) {
        String secretRegion = parameters.get(SECRET_REGION);
        String secretName = parameters.get(SECRET_NAME);
        AWSSecretsManager client = this.clientProvider.getClientForSecretParameters(parameters);
        DescribeSecretRequest request = new DescribeSecretRequest().withSecretId(secretName);
        try {
            return client.describeSecret(request);
        }
        catch (AWSSecretsManagerException e) {
            throw new SecretException(String.format("An error occurred when using AWS Secrets Manager to describe secret: [secretName: %s, secretRegion: %s]", secretName, secretRegion), (Throwable)e);
        }
    }

    protected GetSecretValueResult getSecretValue(Map<String, String> parameters) {
        String secretRegion = parameters.get(SECRET_REGION);
        String secretName = parameters.get(SECRET_NAME);
        AWSSecretsManager client = this.clientProvider.getClientForSecretParameters(parameters);
        GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretName);
        try {
            return client.getSecretValue(getSecretValueRequest);
        }
        catch (AWSSecretsManagerException e) {
            throw new SecretException(String.format("An error occurred when using AWS Secrets Manager to fetch: [secretName: %s, secretRegion: %s]", secretName, secretRegion), (Throwable)e);
        }
    }

    private byte[] getSecretString(Map<String, String> parameters) {
        String secretKey = parameters.get(SECRET_KEY);
        if (secretKey == null) {
            return this.getSecretValue(parameters).getSecretString().getBytes(StandardCharsets.UTF_8);
        }
        return Optional.ofNullable((String)this.cache.computeIfAbsent(parameters.get(SECRET_NAME), ignored -> {
            try {
                return (Map)this.mapper.readerForMapOf(String.class).readValue(this.getSecretValue(parameters).getSecretString());
            }
            catch (JsonProcessingException | IllegalArgumentException e) {
                throw new SecretException(String.format("Failed to parse secret when using AWS Secrets Manager to fetch: %s", parameters), e);
            }
        }).get(secretKey)).orElseThrow(() -> new SecretException(String.format("Specified key not found in AWS Secrets Manager: %s", parameters))).getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

