/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.amazonaws.AmazonClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.S3Object;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.engines.AbstractStorageSecretEngine;
import com.netflix.spinnaker.kork.secrets.engines.S3ConfigurationProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class S3SecretEngine
extends AbstractStorageSecretEngine {
    private static String IDENTIFIER = "s3";
    private final Optional<S3ConfigurationProperties> s3ConfigurationProperties;

    public S3SecretEngine(Optional<S3ConfigurationProperties> s3ConfigurationProperties) {
        this.s3ConfigurationProperties = s3ConfigurationProperties;
    }

    public String identifier() {
        return IDENTIFIER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream downloadRemoteFile(EncryptedSecret encryptedSecret) throws IOException {
        String region = (String)encryptedSecret.getParams().get("r");
        String bucket = (String)encryptedSecret.getParams().get("b");
        String objName = (String)encryptedSecret.getParams().get("f");
        AmazonS3ClientBuilder s3ClientBuilder = AmazonS3ClientBuilder.standard();
        if (this.s3ConfigurationProperties.isPresent()) {
            S3ConfigurationProperties s3ConfigurationProperties = this.s3ConfigurationProperties.get();
            if (StringUtils.isBlank((CharSequence)s3ConfigurationProperties.getEndpointUrl())) throw new SecretException(String.format("Endpoint not found in properties: s3.secret.endpoint-url", new Object[0]));
            s3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3ConfigurationProperties.getEndpointUrl(), region));
            s3ClientBuilder.setPathStyleAccessEnabled(Boolean.valueOf(s3ConfigurationProperties.isPathStyleAccessEnabled()));
        } else {
            s3ClientBuilder = (AmazonS3ClientBuilder)s3ClientBuilder.withRegion(region);
        }
        AmazonS3 s3Client = (AmazonS3)s3ClientBuilder.build();
        try {
            if (!s3Client.doesBucketExistV2(bucket)) {
                throw new SecretException(String.format("S3 Bucket does not exist. Bucket: %s, Region: %s", bucket, region));
            }
            S3Object s3Object = s3Client.getObject(bucket, objName);
            return s3Object.getObjectContent();
        }
        catch (AmazonS3Exception ex) {
            StringBuilder sb = new StringBuilder("Error reading contents of S3 -- ");
            if (403 == ex.getStatusCode()) {
                sb.append(String.format("Unauthorized access. Check connectivity and permissions to the bucket. -- Bucket: %s, Object: %s, Region: %s.\nError: %s ", bucket, objName, region, ex.toString()));
                throw new SecretException(sb.toString(), (Throwable)ex);
            } else if (404 == ex.getStatusCode()) {
                sb.append(String.format("Not found. Does secret file exist? -- Bucket: %s, Object: %s, Region: %s.\nError: %s", bucket, objName, region, ex.toString()));
                throw new SecretException(sb.toString(), (Throwable)ex);
            } else {
                sb.append(String.format("Error: %s", ex.toString()));
            }
            throw new SecretException(sb.toString(), (Throwable)ex);
        }
        catch (AmazonClientException ex) {
            throw new SecretException(String.format("Error reading contents of S3. Bucket: %s, Object: %s, Region: %s.\nError: %s", bucket, objName, region, ex.toString()), (Throwable)ex);
        }
    }
}

