/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

class GoogleUtils {
    private static final int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final int READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);

    GoogleUtils() {
    }

    static GoogleCredentials buildGoogleCredentials() throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(Collections.singleton("https://www.googleapis.com/auth/devstorage.read_only"));
        }
        return credentials;
    }

    static HttpTransport buildHttpTransport() {
        try {
            return GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to build trusted transport", e);
        }
    }

    static HttpRequestInitializer setTimeoutsAndRetryBehavior(GoogleCredentials credentials) {
        return new HttpCredentialsAdapter((Credentials)credentials){

            public void initialize(HttpRequest request) throws IOException {
                super.initialize(request);
                request.setConnectTimeout(CONNECT_TIMEOUT);
                request.setReadTimeout(READ_TIMEOUT);
                HttpBackOffUnsuccessfulResponseHandler unsuccessfulResponseHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff());
                unsuccessfulResponseHandler.setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR);
                request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)unsuccessfulResponseHandler);
            }
        };
    }
}

