/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import com.google.auth.oauth2.GoogleCredentials;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.engines.AbstractStorageSecretEngine;
import com.netflix.spinnaker.kork.secrets.engines.GoogleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GcsSecretEngine
extends AbstractStorageSecretEngine {
    private static final Logger log = LoggerFactory.getLogger(GcsSecretEngine.class);
    private static final String IDENTIFIER = "gcs";
    private static final String APPLICATION_NAME = "Spinnaker";
    private final AtomicReference<Storage> googleStorage = new AtomicReference();

    public String identifier() {
        return IDENTIFIER;
    }

    public void validate(EncryptedSecret encryptedSecret) throws InvalidSecretFormatException {
        Set paramNames = encryptedSecret.getParams().keySet();
        if (!paramNames.contains("b")) {
            throw new InvalidSecretFormatException("Storage bucket parameter is missing (b=...)");
        }
        if (!paramNames.contains("f")) {
            throw new InvalidSecretFormatException("Storage file parameter is missing (f=...)");
        }
    }

    protected InputStream downloadRemoteFile(EncryptedSecret encryptedSecret) {
        String bucket = (String)encryptedSecret.getParams().get("b");
        String objName = (String)encryptedSecret.getParams().get("f");
        log.info("Getting contents of object {} from bucket {}", (Object)objName, (Object)bucket);
        try {
            Storage storage = this.getStorage();
            return storage.objects().get(bucket, objName).executeMediaAsInputStream();
        }
        catch (IOException e) {
            throw new SecretException(String.format("Error reading contents of GCS. Bucket: %s, Object: %s.\nError: %s", bucket, objName, e.toString()));
        }
    }

    private Storage getStorage() throws IOException {
        Storage storage = this.googleStorage.get();
        if (storage == null) {
            HttpTransport httpTransport = GoogleUtils.buildHttpTransport();
            GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
            GoogleCredentials credentials = GoogleUtils.buildGoogleCredentials();
            HttpRequestInitializer requestInitializer = GoogleUtils.setTimeoutsAndRetryBehavior(credentials);
            storage = new Storage.Builder(httpTransport, (JsonFactory)jsonFactory, requestInitializer).setApplicationName(APPLICATION_NAME).build();
            this.googleStorage.compareAndSet(null, storage);
        }
        return storage;
    }
}

