/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import java.util.HashMap;
import java.util.Map;

public class EncryptedSecret {
    public static final String ENCRYPTED_STRING_PREFIX = "encrypted:";
    public static final String ENCRYPTED_FILE_PREFIX = "encryptedFile:";
    private static final String ENCRYPTED_TAG_REGEX = ".+(![a-zA-Z0-9]+:.+)+";
    private static final String ENCRYPTED_STRING_REGEX = "encrypted:.+(![a-zA-Z0-9]+:.+)+";
    private static final String ENCRYPTED_FILE_REGEX = "encryptedFile:.+(![a-zA-Z0-9]+:.+)+";
    private String engineIdentifier;
    private Map<String, String> params = new HashMap<String, String>();
    private boolean encryptedFile = false;

    EncryptedSecret(String secretConfig) {
        this.update(secretConfig);
    }

    public static EncryptedSecret parse(String secretConfig) {
        if (EncryptedSecret.isEncryptedSecret(secretConfig)) {
            return new EncryptedSecret(secretConfig);
        }
        return null;
    }

    protected void update(String secretConfig) {
        this.encryptedFile = EncryptedSecret.isEncryptedFile(secretConfig);
        String[] keyValues = secretConfig.split("!");
        if (keyValues.length < 2) {
            throw new InvalidSecretFormatException("Invalid encrypted secret format, must have at least one parameter");
        }
        for (int i = 0; i < keyValues.length; ++i) {
            String[] keyV = keyValues[i].split(":", 2);
            if (keyV.length != 2) {
                throw new InvalidSecretFormatException("Invalid encrypted secret format, keys and values must be delimited by ':'");
            }
            if (i == 0) {
                this.engineIdentifier = keyV[1];
                continue;
            }
            this.params.put(keyV[0], keyV[1]);
        }
    }

    public static boolean isEncryptedSecret(String secretConfig) {
        return secretConfig != null && (EncryptedSecret.matchesEncryptedStringSyntax(secretConfig) || EncryptedSecret.matchesEncryptedFileSyntax(secretConfig));
    }

    public static boolean isEncryptedFile(String secretConfig) {
        return secretConfig != null && EncryptedSecret.matchesEncryptedFileSyntax(secretConfig);
    }

    private static boolean matchesEncryptedStringSyntax(String secretConfig) {
        return secretConfig.startsWith(ENCRYPTED_STRING_PREFIX) && secretConfig.matches(ENCRYPTED_STRING_REGEX);
    }

    private static boolean matchesEncryptedFileSyntax(String secretConfig) {
        return secretConfig.toLowerCase().startsWith(ENCRYPTED_FILE_PREFIX.toLowerCase()) && secretConfig.matches(ENCRYPTED_FILE_REGEX);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptedSecret)) {
            return false;
        }
        EncryptedSecret other = (EncryptedSecret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$engineIdentifier = this.getEngineIdentifier();
        String other$engineIdentifier = other.getEngineIdentifier();
        if (this$engineIdentifier == null ? other$engineIdentifier != null : !this$engineIdentifier.equals(other$engineIdentifier)) {
            return false;
        }
        Map<String, String> this$params = this.getParams();
        Map<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        return this.isEncryptedFile() == other.isEncryptedFile();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptedSecret;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $engineIdentifier = this.getEngineIdentifier();
        result = result * 59 + ($engineIdentifier == null ? 43 : $engineIdentifier.hashCode());
        Map<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        result = result * 59 + (this.isEncryptedFile() ? 79 : 97);
        return result;
    }

    public EncryptedSecret() {
    }

    public String getEngineIdentifier() {
        return this.engineIdentifier;
    }

    public void setEngineIdentifier(String engineIdentifier) {
        this.engineIdentifier = engineIdentifier;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean isEncryptedFile() {
        return this.encryptedFile;
    }
}

