/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.google.common.base.Splitter;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractStorageSecretEngine
implements SecretEngine {
    protected static final String STORAGE_BUCKET = "b";
    protected static final String STORAGE_REGION = "r";
    protected static final String STORAGE_FILE_URI = "f";
    protected static final String STORAGE_PROP_KEY = "k";
    protected Map<String, Map<String, Object>> cache = new HashMap<String, Map<String, Object>>();

    @Override
    public byte[] decrypt(EncryptedSecret encryptedSecret) {
        String fileUri = encryptedSecret.getParams().get(STORAGE_FILE_URI);
        String key = encryptedSecret.getParams().get(STORAGE_PROP_KEY);
        InputStream is = null;
        try {
            if (key == null || !this.cache.containsKey(fileUri)) {
                is = this.downloadRemoteFile(encryptedSecret);
            }
            if (key == null) {
                byte[] byArray = this.readAll(is);
                return byArray;
            }
            if (!this.cache.containsKey(fileUri)) {
                this.parseAsYaml(fileUri, is);
            }
            byte[] byArray = this.getParsedValue(fileUri, key);
            return byArray;
        }
        catch (IOException e) {
            throw new SecretDecryptionException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void validate(EncryptedSecret encryptedSecret) throws InvalidSecretFormatException {
        Set<String> paramNames = encryptedSecret.getParams().keySet();
        if (!paramNames.contains(STORAGE_BUCKET)) {
            throw new InvalidSecretFormatException("Storage bucket parameter is missing (b=...)");
        }
        if (!paramNames.contains(STORAGE_REGION)) {
            throw new InvalidSecretFormatException("Storage region parameter is missing (r=...)");
        }
        if (!paramNames.contains(STORAGE_FILE_URI)) {
            throw new InvalidSecretFormatException("Storage file parameter is missing (f=...)");
        }
    }

    @Override
    public EncryptedSecret encrypt(String secretToEncrypt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    protected abstract InputStream downloadRemoteFile(EncryptedSecret var1) throws IOException;

    protected byte[] readAll(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int read;
            byte[] buf = new byte[4096];
            while ((read = inputStream.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    protected void parseAsYaml(String fileURI, InputStream inputStream) {
        Map parsed = (Map)new Yaml().load(inputStream);
        this.cache.put(fileURI, parsed);
    }

    protected byte[] getParsedValue(String fileURI, String yamlPath) throws SecretDecryptionException {
        Map parsed = this.cache.get(fileURI);
        for (String pathElt : Splitter.on((String)".").split((CharSequence)yamlPath)) {
            Object o = parsed.get(pathElt);
            if (o instanceof Map) {
                parsed = (Map)o;
                continue;
            }
            if (o instanceof List) {
                parsed = (Map)((List)o).get(Integer.valueOf(pathElt));
                continue;
            }
            return ((String)o).getBytes();
        }
        throw new SecretDecryptionException("Invalid secret key specified: " + yamlPath);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

