/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import org.springframework.core.env.EnumerablePropertySource;

public class SecretAwarePropertySource
extends EnumerablePropertySource<EnumerablePropertySource> {
    private SecretManager secretManager;

    public SecretAwarePropertySource(EnumerablePropertySource source, SecretManager secretManager) {
        super(source.getName(), (Object)source);
        this.secretManager = secretManager;
    }

    public Object getProperty(String name) {
        Object o = ((EnumerablePropertySource)this.source).getProperty(name);
        if (o instanceof String && EncryptedSecret.isEncryptedSecret((String)o)) {
            String propertyValue = (String)o;
            if (this.secretManager == null) {
                throw new SecretException("No secret manager to decrypt value of " + name);
            }
            String lName = name.toLowerCase();
            if (this.isSamlFile(lName)) {
                return "file:" + this.secretManager.decryptAsFile(propertyValue).toString();
            }
            if (this.isFile(lName) || EncryptedSecret.isEncryptedFile(propertyValue)) {
                return this.secretManager.decryptAsFile(propertyValue).toString();
            }
            return this.secretManager.decrypt(propertyValue);
        }
        return o;
    }

    @Deprecated
    private boolean isFile(String name) {
        return name.endsWith("file") || name.endsWith("path") || name.endsWith("truststore");
    }

    @Deprecated
    private boolean isSamlFile(String name) {
        return name.endsWith("keystore") || name.endsWith("metadataurl");
    }

    public String[] getPropertyNames() {
        return ((EnumerablePropertySource)this.source).getPropertyNames();
    }

    public void setSecretManager(SecretManager secretManager) {
        this.secretManager = secretManager;
    }

    public SecretManager getSecretManager() {
        return this.secretManager;
    }
}

