/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.SecretAwarePropertySource;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SecretBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private ConfigurableApplicationContext applicationContext;
    private SecretManager secretManager;

    SecretBeanPostProcessor(ConfigurableApplicationContext applicationContext, SecretManager secretManager) {
        this.applicationContext = applicationContext;
        this.secretManager = secretManager;
        MutablePropertySources propertySources = applicationContext.getEnvironment().getPropertySources();
        ArrayList<EnumerablePropertySource> enumerableSources = new ArrayList<EnumerablePropertySource>();
        for (PropertySource ps : propertySources) {
            if (!(ps instanceof EnumerablePropertySource)) continue;
            enumerableSources.add((EnumerablePropertySource)ps);
        }
        for (EnumerablePropertySource s : enumerableSources) {
            propertySources.replace(s.getName(), (PropertySource)new SecretAwarePropertySource(s, secretManager));
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return -2147483640;
    }
}

