/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.netflix.spinnaker.kork.secrets.SecretBeanPostProcessor;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMapper;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMixin;
import com.netflix.spinnaker.kork.secrets.user.UserSecretTypeProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

@Configuration
@ComponentScan
public class SecretConfiguration {
    private static final Logger log = LogManager.getLogger(SecretConfiguration.class);

    @Bean
    static SecretBeanPostProcessor secretBeanPostProcessor(ConfigurableApplicationContext applicationContext, SecretManager secretManager) {
        return new SecretBeanPostProcessor(applicationContext, secretManager);
    }

    @Bean
    public UserSecretTypeProvider defaultUserSecretTypeProvider(ResourceLoader loader) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(loader);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(UserSecret.class));
        return () -> provider.findCandidateComponents(UserSecret.class.getPackageName()).stream().map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).map(className -> SecretConfiguration.tryLoadUserSecretClass(className, loader.getClassLoader())).filter(Objects::nonNull);
    }

    @Nullable
    private static Class<? extends UserSecret> tryLoadUserSecretClass(@Nonnull String className, @Nullable ClassLoader classLoader) {
        try {
            return ClassUtils.forName((String)className, (ClassLoader)classLoader).asSubclass(UserSecret.class);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load discovered UserSecret class {}. User secrets with this type will not be parseable.", (Object)className, (Object)e);
            return null;
        }
    }

    @Bean
    public UserSecretMapper userSecretMapper(List<UserSecretTypeProvider> userSecretTypeProviders) {
        List<CBORMapper> mappers = List.of(new ObjectMapper(), new YAMLMapper(), new CBORMapper());
        Set classes = userSecretTypeProviders.stream().flatMap(UserSecretTypeProvider::getUserSecretTypes).filter(Objects::nonNull).collect(Collectors.toSet());
        mappers.forEach(mapper -> mapper.addMixIn(UserSecret.class, UserSecretMixin.class).registerSubtypes((Collection)classes));
        return new UserSecretMapper(mappers);
    }
}

