/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.StandardSecretParameter;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import javax.annotation.Nonnull;

public interface SecretEngine {
    public String identifier();

    public byte[] decrypt(EncryptedSecret var1);

    @Nonnull
    default public UserSecret decrypt(@Nonnull UserSecretReference reference) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void validate(EncryptedSecret var1);

    default public EncryptedSecret encrypt(String secretToEncrypt) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    default public void validate(@Nonnull UserSecretReference reference) {
        if (!reference.getParameters().containsKey(StandardSecretParameter.ENCODING.getParameterName())) {
            throw new InvalidSecretFormatException(String.format("No encoding parameter specified (%s=...) in %s", StandardSecretParameter.ENCODING.getParameterName(), reference));
        }
    }

    public void clearCache();
}

