/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.engines;

import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.user.OpaqueUserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class NoopSecretEngine
implements SecretEngine {
    private static final String IDENTIFIER = "noop";
    private static final String PARAM_VALUE = "v";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public byte[] decrypt(EncryptedSecret encryptedSecret) {
        return encryptedSecret.getParams().get(PARAM_VALUE).getBytes();
    }

    @Override
    @Nonnull
    public UserSecret decrypt(@Nonnull UserSecretReference reference) {
        return OpaqueUserSecret.builder().stringData(Map.copyOf(reference.getParameters())).build();
    }

    @Override
    public void validate(EncryptedSecret encryptedSecret) {
    }

    @Override
    public void validate(@Nonnull UserSecretReference reference) {
    }

    @Override
    public void clearCache() {
    }
}

