/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

@JsonTypeName(value="opaque")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpaqueUserSecret
implements UserSecret {
    public static final String TYPE = "opaque";
    private final List<String> roles;
    private final Map<String, byte[]> data;
    private final Map<String, String> stringData;

    @JsonCreator
    public OpaqueUserSecret(@JsonProperty(value="roles") List<String> roles, @JsonProperty(value="data") Map<String, byte[]> data, @JsonProperty(value="stringData") Map<String, String> stringData) {
        this.roles = roles != null ? roles : List.of();
        this.data = data != null ? data : Map.of();
        this.stringData = stringData != null ? stringData : Map.of();
    }

    @Override
    @Nonnull
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public String getSecretString(@Nonnull String key) {
        String value = this.stringData.get(key);
        if (value != null) {
            return value;
        }
        throw new NoSuchElementException(key);
    }

    @Override
    @Nonnull
    public byte[] getSecretBytes(@Nonnull String key) {
        byte[] bytes = this.data.get(key);
        if (bytes != null) {
            return bytes;
        }
        String value = this.stringData.get(key);
        if (value != null) {
            return value.getBytes(StandardCharsets.UTF_8);
        }
        throw new NoSuchElementException(key);
    }

    public static OpaqueUserSecretBuilder builder() {
        return new OpaqueUserSecretBuilder();
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, byte[]> getData() {
        return this.data;
    }

    public Map<String, String> getStringData() {
        return this.stringData;
    }

    public static class OpaqueUserSecretBuilder {
        private List<String> roles;
        private Map<String, byte[]> data;
        private Map<String, String> stringData;

        OpaqueUserSecretBuilder() {
        }

        @JsonProperty(value="roles")
        public OpaqueUserSecretBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        @JsonProperty(value="data")
        public OpaqueUserSecretBuilder data(Map<String, byte[]> data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="stringData")
        public OpaqueUserSecretBuilder stringData(Map<String, String> stringData) {
            this.stringData = stringData;
            return this;
        }

        public OpaqueUserSecret build() {
            return new OpaqueUserSecret(this.roles, this.data, this.stringData);
        }

        public String toString() {
            return "OpaqueUserSecret.OpaqueUserSecretBuilder(roles=" + this.roles + ", data=" + this.data + ", stringData=" + this.stringData + ")";
        }
    }
}

