/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.SecretEngineRegistry;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class UserSecretManager {
    private final SecretEngineRegistry registry;

    @Nonnull
    public UserSecret getUserSecret(@Nonnull UserSecretReference reference) {
        String engineIdentifier = reference.getEngineIdentifier();
        SecretEngine engine = this.registry.getEngine(engineIdentifier);
        if (engine == null) {
            throw new SecretDecryptionException("Unknown secret engine identifier: " + engineIdentifier);
        }
        engine.validate(reference);
        return engine.decrypt(reference);
    }

    public UserSecretManager(SecretEngineRegistry registry) {
        this.registry = registry;
    }
}

