/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class UserSecretMapper {
    private final Map<String, ObjectMapper> mappersByEncodingFormat = new TreeMap<String, ObjectMapper>(String.CASE_INSENSITIVE_ORDER);

    public UserSecretMapper(@Nonnull List<ObjectMapper> mappers) {
        mappers.forEach(mapper -> this.mappersByEncodingFormat.put(mapper.getFactory().getFormatName(), (ObjectMapper)mapper));
    }

    @Nonnull
    public UserSecret deserialize(@Nonnull byte[] input, @Nonnull String encoding) {
        ObjectMapper mapper = this.mappersByEncodingFormat.get(encoding);
        if (mapper == null) {
            throw new InvalidSecretFormatException(String.format("Unsupported user secret encoding: %s. Known encoding formats: %s", encoding, this.mappersByEncodingFormat.keySet()));
        }
        try {
            return (UserSecret)mapper.readValue(input, UserSecret.class);
        }
        catch (IOException e) {
            throw new SecretDecryptionException(e);
        }
    }

    @Nonnull
    public byte[] serialize(@Nonnull UserSecret secret, @Nonnull String encoding) {
        ObjectMapper mapper = this.mappersByEncodingFormat.get(encoding);
        if (mapper == null) {
            throw new InvalidSecretFormatException(String.format("Unsupported user secret encoding: %s. Known encoding formats: %s", encoding, this.mappersByEncodingFormat.keySet()));
        }
        try {
            return mapper.writeValueAsBytes((Object)secret);
        }
        catch (JsonProcessingException e) {
            throw new SecretException(e);
        }
    }
}

