/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.secrets.user.UserSecretData;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public interface UserSecretTypeProvider {
    public Stream<? extends Class<? extends UserSecretData>> getUserSecretTypes();

    public static UserSecretTypeProvider fromPackage(String basePackage, ResourceLoader loader) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(loader);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(UserSecretData.class));
        return () -> provider.findCandidateComponents(basePackage).stream().map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).map(className -> {
            Class<UserSecretData> type = null;
            try {
                type = ClassUtils.forName((String)className, (ClassLoader)loader.getClassLoader()).asSubclass(UserSecretData.class);
            }
            catch (ClassNotFoundException e) {
                LogManager.getLogger().error("Unable to load discovered UserSecret class {}. User secrets with this type will not be parseable.", className, (Object)e);
            }
            return type;
        });
    }
}

