/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.SecretEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecretEngineRegistry {
    private Map<String, SecretEngine> registeredEngines = new HashMap<String, SecretEngine>();
    @Autowired
    private List<SecretEngine> secretEngineList;

    @PostConstruct
    public void init() {
        for (SecretEngine secretEngine : this.secretEngineList) {
            this.registeredEngines.put(secretEngine.identifier(), secretEngine);
        }
    }

    public SecretEngine getEngine(String key) {
        return this.registeredEngines.get(key);
    }

    public Map<String, SecretEngine> getRegisteredEngines() {
        return this.registeredEngines;
    }

    public List<SecretEngine> getSecretEngineList() {
        return this.secretEngineList;
    }
}

