/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.user.StringUserSecretData;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretData;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadata;
import com.netflix.spinnaker.kork.secrets.user.UserSecretSerde;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;

@NonnullByDefault
@Component
public class StringUserSecretSerde
implements UserSecretSerde {
    @Override
    public boolean supports(UserSecretMetadata metadata) {
        return metadata.getType().equals("string");
    }

    @Override
    public UserSecret deserialize(byte[] encoded, UserSecretMetadata metadata) {
        String data = new String(encoded, StandardCharsets.UTF_8);
        return UserSecret.builder().metadata(metadata).data(new StringUserSecretData(data)).build();
    }

    @Override
    public byte[] serialize(UserSecretData secret, UserSecretMetadata metadata) {
        return secret.getSecretString("").getBytes(StandardCharsets.UTF_8);
    }
}

