/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadata;
import com.netflix.spinnaker.kork.secrets.user.UserSecretSerde;
import java.util.stream.StreamSupport;

@NonnullByDefault
public class UserSecretSerdeFactory {
    private final Iterable<UserSecretSerde> serdes;

    public UserSecretSerde serdeFor(UserSecretMetadata metadata) {
        return StreamSupport.stream(this.serdes.spliterator(), false).filter(serde -> serde.supports(metadata)).findFirst().orElseThrow(() -> new InvalidSecretFormatException("Unsupported user secret metadata: " + metadata));
    }

    public UserSecretSerdeFactory(Iterable<UserSecretSerde> serdes) {
        this.serdes = serdes;
    }
}

