/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.SecretEngineRegistry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecretManager {
    private final SecretEngineRegistry secretEngineRegistry;

    @Autowired
    SecretManager(SecretEngineRegistry secretEngineRegistry) {
        this.secretEngineRegistry = secretEngineRegistry;
    }

    public String decrypt(String configValue) {
        if (EncryptedSecret.isEncryptedSecret(configValue)) {
            return new String(this.decryptAsBytes(configValue));
        }
        return configValue;
    }

    public Path decryptAsFile(String filePathOrEncrypted) {
        if (!EncryptedSecret.isEncryptedSecret(filePathOrEncrypted)) {
            return Paths.get(filePathOrEncrypted, new String[0]);
        }
        return this.createTempFile("tmp", this.decryptAsBytes(filePathOrEncrypted));
    }

    public byte[] decryptAsBytes(String encryptedString) {
        EncryptedSecret encryptedSecret = EncryptedSecret.parse(encryptedString);
        if (encryptedSecret == null) {
            return encryptedString.getBytes();
        }
        SecretEngine secretEngine = this.secretEngineRegistry.getEngine(encryptedSecret.getEngineIdentifier());
        if (secretEngine == null) {
            throw new SecretDecryptionException("Secret Engine does not exist: " + encryptedSecret.getEngineIdentifier());
        }
        secretEngine.validate(encryptedSecret);
        return secretEngine.decrypt(encryptedSecret);
    }

    protected Path createTempFile(String prefix, byte[] decryptedContents) {
        try {
            File tempFile = File.createTempFile(prefix, ".secret");
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(decryptedContents);
            tempFile.deleteOnExit();
            bufferedOutputStream.close();
            fileOutputStream.close();
            return tempFile.toPath();
        }
        catch (IOException e) {
            throw new SecretDecryptionException(e.getMessage());
        }
    }

    public SecretEngineRegistry getSecretEngineRegistry() {
        return this.secretEngineRegistry;
    }
}

