/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.secrets.InvalidSecretFormatException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserSecretReference {
    private static final Pattern SECRET_URI = Pattern.compile("^secret(File)?://.+");
    public static final String SECRET_SCHEME = "secret";
    @Nonnull
    private final String engineIdentifier;
    @Nonnull
    private final Map<String, String> parameters = new ConcurrentHashMap<String, String>();

    private UserSecretReference(URI uri) {
        if (!SECRET_SCHEME.equals(uri.getScheme())) {
            throw new InvalidSecretFormatException("Only secret:// URIs supported");
        }
        this.engineIdentifier = uri.getAuthority();
        String[] queryKeyValues = uri.getQuery().split("&");
        if (queryKeyValues.length == 0) {
            throw new InvalidSecretFormatException("Invalid user secret URI has no query parameters defined");
        }
        for (String keyValue : queryKeyValues) {
            String[] pair = keyValue.split("=", 2);
            if (pair.length != 2) {
                throw new InvalidSecretFormatException("Invalid user secret query string; missing parameter value for '" + keyValue + "'");
            }
            this.parameters.put(pair[0], pair[1]);
        }
    }

    @Nonnull
    public static UserSecretReference parse(@Nonnull String input) {
        try {
            return new UserSecretReference(new URI(input));
        }
        catch (URISyntaxException e) {
            throw new InvalidSecretFormatException(e);
        }
    }

    @Nonnull
    public static Optional<UserSecretReference> tryParse(@Nullable Object value) {
        if (!(value instanceof String) || !UserSecretReference.isUserSecret((String)value)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new UserSecretReference(new URI((String)value)));
        }
        catch (InvalidSecretFormatException | URISyntaxException e) {
            return Optional.empty();
        }
    }

    public static boolean isUserSecret(@Nonnull String input) {
        return SECRET_URI.matcher(input).matches();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSecretReference)) {
            return false;
        }
        UserSecretReference other = (UserSecretReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$engineIdentifier = this.getEngineIdentifier();
        String other$engineIdentifier = other.getEngineIdentifier();
        if (this$engineIdentifier == null ? other$engineIdentifier != null : !this$engineIdentifier.equals(other$engineIdentifier)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserSecretReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $engineIdentifier = this.getEngineIdentifier();
        result = result * 59 + ($engineIdentifier == null ? 43 : $engineIdentifier.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "UserSecretReference(engineIdentifier=" + this.getEngineIdentifier() + ", parameters=" + this.getParameters() + ")";
    }

    @Nonnull
    public String getEngineIdentifier() {
        return this.engineIdentifier;
    }

    @Nonnull
    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

