/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.SecretAwarePropertySource;
import com.netflix.spinnaker.kork.secrets.SecretPropertyProcessor;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.stereotype.Component;

@Component
public class SecretAwarePropertySourceRegistrar
implements EnvironmentAware,
BeanFactoryAware,
InitializingBean,
Ordered,
BeanPostProcessor {
    private ConfigurableEnvironment environment;
    private BeanFactory beanFactory;

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void afterPropertiesSet() throws Exception {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        SecretPropertyProcessor processor = (SecretPropertyProcessor)this.beanFactory.getBean(SecretPropertyProcessor.class);
        propertySources.stream().filter(EnumerablePropertySource.class::isInstance).map(source -> (EnumerablePropertySource)source).forEach(source -> propertySources.replace(source.getName(), new SecretAwarePropertySource(source, processor)));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

