/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonDeserialize(builder=UserSecretMetadataBuilder.class)
public class UserSecretMetadata {
    @Nonnull
    private final String type;
    @Nullable
    private final String encoding;
    @Nonnull
    private final List<String> roles;

    UserSecretMetadata(@Nonnull String type, @Nullable String encoding, @Nonnull List<String> roles) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        this.type = type;
        this.encoding = encoding;
        this.roles = roles;
    }

    public static UserSecretMetadataBuilder builder() {
        return new UserSecretMetadataBuilder();
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    public String toString() {
        return "UserSecretMetadata(type=" + this.getType() + ", encoding=" + this.getEncoding() + ", roles=" + this.getRoles() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class UserSecretMetadataBuilder {
        private String type;
        private String encoding;
        private List<String> roles;

        UserSecretMetadataBuilder() {
        }

        public UserSecretMetadataBuilder type(@Nonnull String type) {
            this.type = type;
            return this;
        }

        public UserSecretMetadataBuilder encoding(@Nullable String encoding) {
            this.encoding = encoding;
            return this;
        }

        public UserSecretMetadataBuilder roles(@Nonnull List<String> roles) {
            this.roles = roles;
            return this;
        }

        public UserSecretMetadata build() {
            return new UserSecretMetadata(this.type, this.encoding, this.roles);
        }

        public String toString() {
            return "UserSecretMetadata.UserSecretMetadataBuilder(type=" + this.type + ", encoding=" + this.encoding + ", roles=" + this.roles + ")";
        }
    }
}

