/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.SecretEngine;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

@Component
public class SecretEngineRegistry {
    private final ObjectProvider<SecretEngine> secretEngines;

    public List<SecretEngine> getSecretEngineList() {
        return this.secretEngines.orderedStream().collect(Collectors.toList());
    }

    @Nullable
    public SecretEngine getEngine(String key) {
        return this.secretEngines.orderedStream().filter(secretEngine -> secretEngine.identifier().equals(key)).findFirst().orElse(null);
    }

    public SecretEngineRegistry(ObjectProvider<SecretEngine> secretEngines) {
        this.secretEngines = secretEngines;
    }
}

