/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.SecretEngine;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class SecretSession {
    private SecretManager secretManager;
    Map<String, String> secretCache = new HashMap<String, String>();
    Map<String, Path> secretFileCache = new HashMap<String, Path>();

    public SecretSession(SecretManager secretManager) {
        this.secretManager = secretManager;
    }

    public String decrypt(String encryptedSecret) {
        if (this.secretCache.containsKey(encryptedSecret)) {
            return this.secretCache.get(encryptedSecret);
        }
        String decryptedValue = this.secretManager.decrypt(encryptedSecret);
        this.addCachedSecret(encryptedSecret, decryptedValue);
        return decryptedValue;
    }

    public Path decryptAsFile(String encryptedSecret) {
        if (this.secretFileCache.containsKey(encryptedSecret)) {
            return this.secretFileCache.get(encryptedSecret);
        }
        Path decryptedFile = this.secretManager.decryptAsFile(encryptedSecret);
        this.addCachedSecretFile(encryptedSecret, decryptedFile);
        return decryptedFile;
    }

    public byte[] decryptAsBytes(String encrypted) {
        return this.secretManager.decryptAsBytes(encrypted);
    }

    public void clearCachedSecrets() {
        this.secretCache.clear();
        this.secretFileCache.clear();
        for (SecretEngine se : this.secretManager.getSecretEngineRegistry().getSecretEngineList()) {
            se.clearCache();
        }
    }

    public void addCachedSecret(String encrypted, String decrypted) {
        this.secretCache.put(encrypted, decrypted);
    }

    public void addCachedSecretFile(String encrypted, Path decrypted) {
        this.secretFileCache.put(encrypted, decrypted);
    }
}

