/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.user.UserSecretData;
import com.netflix.spinnaker.kork.secrets.user.UserSecretType;
import java.util.Map;
import java.util.NoSuchElementException;

@NonnullByDefault
@UserSecretType(value="opaque")
public class OpaqueUserSecretData
implements UserSecretData {
    private final Map<String, String> data;

    @JsonCreator
    public OpaqueUserSecretData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String getSecretString(String key) {
        String value = this.data.get(key);
        if (value == null) {
            throw new NoSuchElementException(key);
        }
        return value;
    }

    @JsonValue
    public Map<String, String> getData() {
        return this.data;
    }
}

