/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SecretPropertyProcessor {
    private static final List<String> SAML_FILE_PROPERTY_NAME_ENDINGS = List.of("keystore", "metadataurl");
    private static final List<String> FILE_PROPERTY_NAME_ENDINGS = List.of("file", "path", "truststore");
    private SecretManager secretManager;

    @Nullable
    public Object processPropertyValue(@Nonnull String name, @Nullable Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String string = (String)value;
        if (!EncryptedSecret.isEncryptedSecret(string)) {
            return string;
        }
        if (this.secretManager == null) {
            throw new SecretException("No secret manager to decrypt value of " + name);
        }
        if (SecretPropertyProcessor.isSamlFilePropertyName(name)) {
            Path file = this.secretManager.decryptAsFile(string);
            return "file:" + file;
        }
        if (SecretPropertyProcessor.isFilePropertyName(name) || EncryptedSecret.isEncryptedFile(string)) {
            Path file = this.secretManager.decryptAsFile(string);
            return file.toString();
        }
        return this.secretManager.decrypt(string);
    }

    private static boolean isSamlFilePropertyName(String name) {
        return SAML_FILE_PROPERTY_NAME_ENDINGS.stream().anyMatch(suffix -> StringUtils.endsWithIgnoreCase((String)name, (String)suffix));
    }

    private static boolean isFilePropertyName(String name) {
        return FILE_PROPERTY_NAME_ENDINGS.stream().anyMatch(suffix -> StringUtils.endsWithIgnoreCase((String)name, (String)suffix));
    }

    @Autowired
    public void setSecretManager(SecretManager secretManager) {
        this.secretManager = secretManager;
    }
}

