/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.SecretPropertyProcessor;
import javax.annotation.Nullable;
import org.springframework.core.env.EnumerablePropertySource;

@NonnullByDefault
public class SecretAwarePropertySource<T>
extends EnumerablePropertySource<T> {
    private final EnumerablePropertySource<T> delegate;
    private final SecretPropertyProcessor secretPropertyProcessor;

    SecretAwarePropertySource(EnumerablePropertySource<T> source, SecretPropertyProcessor secretPropertyProcessor) {
        super(source.getName(), source.getSource());
        this.delegate = source;
        this.secretPropertyProcessor = secretPropertyProcessor;
    }

    @Nullable
    public Object getProperty(String name) {
        return this.secretPropertyProcessor.processPropertyValue(name, this.delegate.getProperty(name));
    }

    public String[] getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public boolean containsProperty(String name) {
        return this.delegate.containsProperty(name);
    }

    public EnumerablePropertySource<T> getDelegate() {
        return this.delegate;
    }
}

