/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretData;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadata;
import com.netflix.spinnaker.kork.secrets.user.UserSecretSerde;
import com.netflix.spinnaker.kork.secrets.user.UserSecretType;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@NonnullByDefault
public class DefaultUserSecretSerde
implements UserSecretSerde {
    private final Map<String, Class<? extends UserSecretData>> userSecretTypes = new TreeMap<String, Class<? extends UserSecretData>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ObjectMapper> mappersByEncodingFormat = new TreeMap<String, ObjectMapper>(String.CASE_INSENSITIVE_ORDER);

    public DefaultUserSecretSerde(Collection<ObjectMapper> mappers, Collection<Class<? extends UserSecretData>> types) {
        mappers.forEach(mapper -> this.mappersByEncodingFormat.put(mapper.getFactory().getFormatName(), (ObjectMapper)mapper));
        types.forEach(type -> this.userSecretTypes.put(type.getAnnotation(UserSecretType.class).value(), (Class<? extends UserSecretData>)type));
    }

    @Override
    public boolean supports(UserSecretMetadata metadata) {
        return this.userSecretTypes.containsKey(metadata.getType()) && this.mappersByEncodingFormat.containsKey(metadata.getEncoding());
    }

    @Override
    public UserSecret deserialize(byte[] encoded, UserSecretMetadata metadata) {
        Class<? extends UserSecretData> type = Objects.requireNonNull(this.userSecretTypes.get(metadata.getType()));
        ObjectMapper mapper = Objects.requireNonNull(this.mappersByEncodingFormat.get(metadata.getEncoding()));
        try {
            return UserSecret.builder().metadata(metadata).data((UserSecretData)mapper.readValue(encoded, type)).build();
        }
        catch (IOException e) {
            throw new SecretDecryptionException(e);
        }
    }

    @Override
    public byte[] serialize(UserSecretData secret, UserSecretMetadata metadata) {
        ObjectMapper mapper = Objects.requireNonNull(this.mappersByEncodingFormat.get(metadata.getEncoding()));
        try {
            return mapper.writeValueAsBytes((Object)secret);
        }
        catch (JsonProcessingException e) {
            throw new SecretException(e);
        }
    }
}

