/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.secrets.user;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.user.UserSecretData;
import com.netflix.spinnaker.kork.secrets.user.UserSecretMetadata;
import com.netflix.spinnaker.security.AccessControlled;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;

@NonnullByDefault
public class UserSecret
implements AccessControlled {
    private final UserSecretMetadata metadata;
    private final UserSecretData data;

    public boolean isAuthorized(Authentication authentication, Object authorization) {
        Set userAuthorities = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        Set permittedAuthorities = this.getRoles().stream().map(role -> "ROLE_" + role).collect(Collectors.toSet());
        return permittedAuthorities.isEmpty() || !Collections.disjoint(userAuthorities, permittedAuthorities);
    }

    UserSecret(UserSecretMetadata metadata, UserSecretData data) {
        this.metadata = metadata;
        this.data = data;
    }

    public static UserSecretBuilder builder() {
        return new UserSecretBuilder();
    }

    public UserSecretMetadata getMetadata() {
        return this.metadata;
    }

    public UserSecretData getData() {
        return this.data;
    }

    public String getType() {
        return this.getMetadata().getType();
    }

    public String getEncoding() {
        return this.getMetadata().getEncoding();
    }

    public List<String> getRoles() {
        return this.getMetadata().getRoles();
    }

    public String getSecretString(String key) {
        return this.getData().getSecretString(key);
    }

    public static class UserSecretBuilder {
        private UserSecretMetadata metadata;
        private UserSecretData data;

        UserSecretBuilder() {
        }

        public UserSecretBuilder metadata(UserSecretMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public UserSecretBuilder data(UserSecretData data) {
            this.data = data;
            return this;
        }

        public UserSecret build() {
            return new UserSecret(this.metadata, this.data);
        }

        public String toString() {
            return "UserSecret.UserSecretBuilder(metadata=" + String.valueOf(this.metadata) + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

