/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.netflix.spinnaker.security.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AllowedAccountsAuthorities {
    public static final String PREFIX = "ALLOWED_ACCOUNT_";

    public static Collection<GrantedAuthority> getAllowedAccountAuthorities(UserDetails userDetails) {
        if (userDetails == null || userDetails.getAuthorities() == null || userDetails.getAuthorities().isEmpty()) {
            return Collections.emptySet();
        }
        return userDetails.getAuthorities().stream().filter(a -> a.getAuthority().startsWith(PREFIX)).collect(Collectors.toSet());
    }

    public static Collection<String> getAllowedAccounts(UserDetails userDetails) {
        if (userDetails instanceof User) {
            return ((User)userDetails).getAllowedAccounts();
        }
        return AllowedAccountsAuthorities.getAllowedAccountAuthorities(userDetails).stream().map(a -> a.getAuthority().substring(PREFIX.length())).sorted().collect(Collectors.toList());
    }

    public static Collection<GrantedAuthority> buildAllowedAccounts(Collection<String> accounts) {
        if (accounts == null || accounts.isEmpty()) {
            return Collections.emptySet();
        }
        return accounts.stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(String::toLowerCase).map(s -> PREFIX + s).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }
}

