/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.ThreadContext;

@NonnullByDefault
public class AuthenticatedRequestDecorator {
    public static Runnable wrap(Runnable runnable) {
        Map context = ThreadContext.getContext();
        if (context == null) {
            return runnable;
        }
        return () -> {
            Map originalContext = ThreadContext.getContext();
            ThreadContext.clearMap();
            ThreadContext.putAll((Map)context);
            try {
                runnable.run();
            }
            finally {
                ThreadContext.clearMap();
                if (originalContext != null) {
                    ThreadContext.putAll((Map)originalContext);
                }
            }
        };
    }

    public static <V> Callable<V> wrap(Callable<V> callable) {
        Map context = ThreadContext.getContext();
        if (context == null) {
            return callable;
        }
        return () -> {
            Map originalContext = ThreadContext.getContext();
            ThreadContext.clearMap();
            ThreadContext.putAll((Map)context);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                ThreadContext.clearMap();
                if (originalContext != null) {
                    ThreadContext.putAll((Map)originalContext);
                }
            }
        };
    }
}

