/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.google.common.base.Preconditions;
import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.security.AllowedAccountsAuthorities;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.CollectionUtils;

public class AuthenticatedRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedRequest.class);
    private static final AtomicReference<PrincipalExtractor> PRINCIPAL_EXTRACTOR = new AtomicReference<DefaultPrincipalExtractor>(DefaultPrincipalExtractor.INSTANCE);

    public static void setPrincipalExtractor(PrincipalExtractor principalExtractor) {
        Objects.requireNonNull(principalExtractor, "PrincipalExtractor is required");
        PRINCIPAL_EXTRACTOR.set(principalExtractor);
        log.info("replaced AuthenticatedRequest PrincipalExtractor with {}", (Object)principalExtractor.getClass().getSimpleName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V allowAnonymous(Callable<V> closure) {
        String originalValue = MDC.get((String)Header.XSpinnakerAnonymous);
        MDC.put((String)Header.XSpinnakerAnonymous, (String)"anonymous");
        try {
            V v = closure.call();
            return v;
        }
        finally {
            AuthenticatedRequest.setOrRemoveMdc(Header.XSpinnakerAnonymous, originalValue);
        }
    }

    public static <V> Callable<V> runAs(String username, Callable<V> closure) {
        return AuthenticatedRequest.runAs(username, Collections.emptySet(), closure);
    }

    public static <V> Callable<V> runAs(String username, boolean restoreOriginalContext, Callable<V> closure) {
        return AuthenticatedRequest.runAs(username, Collections.emptySet(), restoreOriginalContext, closure);
    }

    public static <V> Callable<V> runAs(String username, Collection<String> allowedAccounts, Callable<V> closure) {
        return AuthenticatedRequest.runAs(username, allowedAccounts, true, closure);
    }

    public static <V> Callable<V> runAs(String username, Collection<String> allowedAccounts, boolean restoreOriginalContext, Callable<V> closure) {
        UserDetails user = User.withUsername((String)username).password("").authorities(AllowedAccountsAuthorities.buildAllowedAccounts(allowedAccounts)).build();
        return AuthenticatedRequest.wrapCallableForPrincipal(closure, restoreOriginalContext, user);
    }

    public static <V> Callable<V> propagate(Callable<V> closure) {
        return AuthenticatedRequest.wrapCallableForPrincipal(closure, true, AuthenticatedRequest.principal());
    }

    public static <V> Callable<V> propagate(Callable<V> closure, boolean restoreOriginalContext) {
        return AuthenticatedRequest.wrapCallableForPrincipal(closure, restoreOriginalContext, AuthenticatedRequest.principal());
    }

    @Deprecated
    public static <V> Callable<V> propagate(Callable<V> closure, Object principal) {
        return AuthenticatedRequest.wrapCallableForPrincipal(closure, true, principal);
    }

    @Deprecated
    public static <V> Callable<V> propagate(Callable<V> closure, boolean restoreOriginalContext, Object principal) {
        return AuthenticatedRequest.wrapCallableForPrincipal(closure, restoreOriginalContext, principal);
    }

    private static <V> Callable<V> wrapCallableForPrincipal(Callable<V> closure, boolean restoreOriginalContext, Object principal) {
        String spinnakerUser = AuthenticatedRequest.getSpinnakerUser(principal).orElse(null);
        String userOrigin = AuthenticatedRequest.getSpinnakerUserOrigin().orElse(null);
        String executionId = AuthenticatedRequest.getSpinnakerExecutionId().orElse(null);
        String requestId = AuthenticatedRequest.getSpinnakerRequestId().orElse(null);
        String spinnakerAccounts = AuthenticatedRequest.getSpinnakerAccounts(principal).orElse(null);
        String spinnakerApp = AuthenticatedRequest.getSpinnakerApplication().orElse(null);
        return () -> {
            Map originalMdc = MDC.getCopyOfContextMap();
            try {
                AuthenticatedRequest.setOrRemoveMdc(Header.USER.getHeader(), spinnakerUser);
                AuthenticatedRequest.setOrRemoveMdc(Header.USER_ORIGIN.getHeader(), userOrigin);
                AuthenticatedRequest.setOrRemoveMdc(Header.ACCOUNTS.getHeader(), spinnakerAccounts);
                AuthenticatedRequest.setOrRemoveMdc(Header.REQUEST_ID.getHeader(), requestId);
                AuthenticatedRequest.setOrRemoveMdc(Header.EXECUTION_ID.getHeader(), executionId);
                AuthenticatedRequest.setOrRemoveMdc(Header.APPLICATION.getHeader(), spinnakerApp);
                Object v = closure.call();
                return v;
            }
            finally {
                AuthenticatedRequest.clear();
                if (restoreOriginalContext && originalMdc != null) {
                    MDC.setContextMap((Map)originalMdc);
                }
            }
        };
    }

    public static Map<String, Optional<String>> getAuthenticationHeaders() {
        HashMap<String, Optional<String>> headers = new HashMap<String, Optional<String>>();
        headers.put(Header.USER.getHeader(), AuthenticatedRequest.getSpinnakerUser());
        headers.put(Header.ACCOUNTS.getHeader(), AuthenticatedRequest.getSpinnakerAccounts());
        Map allMdcEntries = MDC.getCopyOfContextMap();
        if (allMdcEntries != null) {
            for (Map.Entry mdcEntry : allMdcEntries.entrySet()) {
                boolean isSpinnakerAuthHeader;
                String header = (String)mdcEntry.getKey();
                boolean isSpinnakerHeader = header.toLowerCase().startsWith(Header.XSpinnakerPrefix.toLowerCase());
                boolean bl = isSpinnakerAuthHeader = Header.USER.getHeader().equalsIgnoreCase(header) || Header.ACCOUNTS.getHeader().equalsIgnoreCase(header);
                if (!isSpinnakerHeader || isSpinnakerAuthHeader) continue;
                headers.put(header, Optional.ofNullable((String)mdcEntry.getValue()));
            }
        }
        return headers;
    }

    public static Optional<String> getSpinnakerUser() {
        return PRINCIPAL_EXTRACTOR.get().getSpinnakerUser();
    }

    private static Optional<String> getSpinnakerUser(Object principal) {
        return PRINCIPAL_EXTRACTOR.get().getSpinnakerUser(principal);
    }

    public static Optional<String> getSpinnakerAccounts() {
        return PRINCIPAL_EXTRACTOR.get().getSpinnakerAccounts();
    }

    private static Optional<String> getSpinnakerAccounts(Object principal) {
        return PRINCIPAL_EXTRACTOR.get().getSpinnakerAccounts(principal);
    }

    public static Optional<String> getSpinnakerRequestId() {
        return Optional.of(AuthenticatedRequest.get(Header.REQUEST_ID).orElse(AuthenticatedRequest.getSpinnakerExecutionId().map(id -> String.format("%s:%s", id, UUID.randomUUID().toString())).orElse(UUID.randomUUID().toString())));
    }

    public static Optional<String> getSpinnakerExecutionType() {
        return AuthenticatedRequest.get(Header.EXECUTION_TYPE);
    }

    public static Optional<String> getSpinnakerUserOrigin() {
        return AuthenticatedRequest.get(Header.USER_ORIGIN);
    }

    public static Optional<String> getSpinnakerExecutionId() {
        return AuthenticatedRequest.get(Header.EXECUTION_ID);
    }

    public static Optional<String> getSpinnakerApplication() {
        return AuthenticatedRequest.get(Header.APPLICATION);
    }

    public static Optional<String> get(Header header) {
        return AuthenticatedRequest.get(header.getHeader());
    }

    public static Optional<String> get(String header) {
        return Optional.ofNullable(MDC.get((String)header));
    }

    public static void setAccounts(String accounts) {
        AuthenticatedRequest.set(Header.ACCOUNTS, accounts);
    }

    public static void setUser(String user) {
        AuthenticatedRequest.set(Header.USER, user);
    }

    public static void setUserOrigin(String value) {
        AuthenticatedRequest.set(Header.USER_ORIGIN, value);
    }

    public static void setRequestId(String value) {
        AuthenticatedRequest.set(Header.REQUEST_ID, value);
    }

    public static void setExecutionId(String value) {
        AuthenticatedRequest.set(Header.EXECUTION_ID, value);
    }

    public static void setApplication(String value) {
        AuthenticatedRequest.set(Header.APPLICATION, value);
    }

    public static void setExecutionType(String value) {
        AuthenticatedRequest.set(Header.EXECUTION_TYPE, value);
    }

    public static void set(Header header, String value) {
        AuthenticatedRequest.set(header.getHeader(), value);
    }

    public static void set(String header, String value) {
        Preconditions.checkArgument((boolean)header.startsWith(Header.XSpinnakerPrefix), (String)"Header '%s' does not start with 'X-SPINNAKER-'", (Object)header);
        MDC.put((String)header, (String)value);
    }

    public static void clear() {
        MDC.clear();
        try {
            Class<?> log4jMDC = Class.forName("org.apache.log4j.MDC");
            log4jMDC.getDeclaredMethod("clear", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object principal() {
        return PRINCIPAL_EXTRACTOR.get().principal();
    }

    private static void setOrRemoveMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    private static class DefaultPrincipalExtractor
    implements PrincipalExtractor {
        private static final DefaultPrincipalExtractor INSTANCE = new DefaultPrincipalExtractor();

        private DefaultPrincipalExtractor() {
        }
    }

    public static interface PrincipalExtractor {
        default public Object principal() {
            return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getPrincipal).orElse(null);
        }

        default public Optional<String> getSpinnakerAccounts() {
            return this.getSpinnakerAccounts(this.principal());
        }

        default public Optional<String> getSpinnakerAccounts(Object principal) {
            Collection<String> allowedAccounts;
            if (principal instanceof UserDetails && !CollectionUtils.isEmpty(allowedAccounts = AllowedAccountsAuthorities.getAllowedAccounts((UserDetails)principal))) {
                return Optional.of(String.join((CharSequence)",", allowedAccounts));
            }
            return AuthenticatedRequest.get(Header.ACCOUNTS);
        }

        default public Optional<String> getSpinnakerUser() {
            return this.getSpinnakerUser(this.principal());
        }

        default public Optional<String> getSpinnakerUser(Object principal) {
            return principal instanceof UserDetails ? Optional.ofNullable(((UserDetails)principal).getUsername()) : AuthenticatedRequest.get(Header.USER);
        }
    }
}

