/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.netflix.spinnaker.security.AccessControlled;
import com.netflix.spinnaker.security.SpinnakerAuthorities;
import com.netflix.spinnaker.security.SpinnakerUsers;
import java.io.Serializable;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;

public abstract class AbstractPermissionEvaluator
implements PermissionEvaluator {
    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        if (this.isDisabled()) {
            return true;
        }
        if (authentication == null || targetDomainObject == null) {
            return false;
        }
        if (SpinnakerAuthorities.isAdmin(authentication)) {
            return true;
        }
        if (targetDomainObject instanceof AccessControlled) {
            return ((AccessControlled)targetDomainObject).isAuthorized(authentication, permission);
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (this.isDisabled()) {
            return true;
        }
        return this.hasPermission(SpinnakerUsers.getUserId(authentication), targetId, targetType, permission);
    }

    protected boolean isDisabled() {
        return false;
    }

    public abstract boolean hasPermission(String var1, Serializable var2, String var3, Object var4);
}

