/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import javax.annotation.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@NonnullByDefault
public class SpinnakerUsers {
    public static final String ANONYMOUS = "anonymous";

    public static String getUserId(@Nullable Authentication authentication) {
        return authentication != null ? authentication.getName() : ANONYMOUS;
    }

    public static String getCurrentUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return SpinnakerUsers.getUserId(authentication);
        }
        return AuthenticatedRequest.getSpinnakerUser().orElse(ANONYMOUS);
    }
}

