/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class SpinnakerAuthorities {
    private static final String ROLE_PREFIX = "ROLE_";
    public static final String ADMIN = "SPINNAKER_ADMIN";
    public static final GrantedAuthority ADMIN_AUTHORITY = new SimpleGrantedAuthority("SPINNAKER_ADMIN");
    public static final GrantedAuthority ANONYMOUS_AUTHORITY = SpinnakerAuthorities.forRoleName("ANONYMOUS");

    @Nonnull
    public static GrantedAuthority forRoleName(@Nonnull String role) {
        return new SimpleGrantedAuthority(ROLE_PREFIX + role);
    }

    public static boolean isAdmin(@Nullable Authentication authentication) {
        return authentication != null && authentication.getAuthorities().contains(ADMIN_AUTHORITY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasRole(@Nullable Authentication authentication, @Nonnull String role) {
        if (authentication == null) return false;
        if (!SpinnakerAuthorities.streamRoles(authentication).anyMatch(role::equals)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAnyRole(@Nullable Authentication authentication, @Nonnull Collection<String> roles) {
        if (authentication == null) return false;
        if (!SpinnakerAuthorities.streamRoles(authentication).anyMatch(roles::contains)) return false;
        return true;
    }

    @Nonnull
    public static List<String> getRoles(@Nullable Authentication authentication) {
        if (authentication == null) {
            return List.of();
        }
        return SpinnakerAuthorities.streamRoles(authentication).distinct().collect(Collectors.toList());
    }

    @Nonnull
    private static Stream<String> streamRoles(@Nonnull Authentication authentication) {
        return authentication.getAuthorities().stream().filter(SpinnakerAuthorities::isRole).map(SpinnakerAuthorities::getRole);
    }

    private static boolean isRole(@Nonnull GrantedAuthority authority) {
        return authority.getAuthority().startsWith(ROLE_PREFIX);
    }

    private static String getRole(@Nonnull GrantedAuthority authority) {
        return authority.getAuthority().substring(ROLE_PREFIX.length());
    }
}

