/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.security;

import com.netflix.spinnaker.kork.annotations.Alpha;
import com.netflix.spinnaker.security.AccessControlled;
import com.netflix.spinnaker.security.SpinnakerAuthorities;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.security.core.Authentication;

@Alpha
public interface PermissionMapControlled<Authorization extends Enum<Authorization>>
extends AccessControlled {
    @Nullable
    public Authorization valueOf(@Nullable Object var1);

    @Nonnull
    default public Map<Authorization, Set<String>> getPermissions() {
        return Map.of();
    }

    @Override
    default public boolean isAuthorized(Authentication authentication, Object authorization) {
        Authorization auth = this.valueOf(authorization);
        if (auth == null) {
            return false;
        }
        Set<String> permittedRoles = this.getPermissions().getOrDefault(auth, Set.of());
        return permittedRoles.isEmpty() || SpinnakerAuthorities.hasAnyRole(authentication, permittedRoles);
    }
}

